#include <stdio.h>
#include <stdlib.h>

typedef long long ll;

typedef struct {
    ll x;
    ll h;
    int idx; 
} Jarbol;

int cmp(const void *a, const void *b) {
    Jarbol *pa = (Jarbol *)a;
    Jarbol *pb = (Jarbol *)b;
    if (pa->x < pb->x) return -1;
    if (pa->x > pb->x) return 1;
    return 0;
}

ll min_ll(ll a, ll b) { return a < b ? a : b; }

int main() {
    int n;
    scanf("%d", &n);
    Jarbol jar[n];
    for (int i = 0; i < n; i++) {
        scanf("%lld", &jar[i].x);
        jar[i].idx = i;
    }
    for (int i = 0; i < n; i++) {
        scanf("%lld", &jar[i].h);
    }

    qsort(jar, n, sizeof(Jarbol), cmp);

    ll res[n];
    for (int i = 0; i < n; i++) res[i] = -1;

    
    for (int i = 0; i < n; i++) {
        ll qx = jar[i].x, qh = jar[i].h;
        ll best = (ll)1e18;

        
        if (qh <= 0) best = 0;
        else {
            
            if (i > 0) {
                ll x1 = jar[i-1].x, h1 = jar[i-1].h;
                ll x2 = jar[i].x, h2 = jar[i].h;

                
                ll p = (h1 - h2 + x2 - x1)/2;
                if (p < x1) p = x1;
                if (p > x2) p = x2;

                
                ll d1 = llabs(x1 - qx) + llabs(h1 - qh);
                ll d2 = llabs(p - qx) + llabs((h1-(p-x1)) - qh);
                ll d3 = llabs(x2 - qx) + llabs(h2 - qh);
                ll local_min = min_ll(d1, min_ll(d2,d3));
                if (local_min < best) best = local_min;
            }
            if (i < n-1) {
                ll x1 = jar[i].x, h1 = jar[i].h;
                ll x2 = jar[i+1].x, h2 = jar[i+1].h;

                ll p = (h1 - h2 + x2 - x1)/2;
                if (p < x1) p = x1;
                if (p > x2) p = x2;

                ll d1 = llabs(x1 - qx) + llabs(h1 - qh);
                ll d2 = llabs(p - qx) + llabs((h1-(p-x1)) - qh);
                ll d3 = llabs(x2 - qx) + llabs(h2 - qh);
                ll local_min = min_ll(d1, min_ll(d2,d3));
                if (local_min < best) best = local_min;
            }
        }

        if (best >= (ll)1e18) res[jar[i].idx] = -1;
        else res[jar[i].idx] = best;
    }

    for (int i = 0; i < n; i++) {
        printf("%lld\n", res[i]);
    }

    return 0;
}